﻿var offlineMessaging = {
    datatable: null,
    refreshDataTable: function () {
        offlineMessaging.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-messagesTable").a4datatable({
            height: "full",
            displayColumnSelector: false,
            ajaxAction: a4.getAction("GetMessages", "Offline", "Messaging"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Visible": false, "Class": "id" },
                { "Name": "SenderName", "Title": resources.SenderName },
                { "Name": "RecipientNames", "Title": resources.RecipientNames, "Visible": false, "Sortable": false },
                { "Name": "CreatedOn", "Title": resources.Received },
                { "Name": "ShortMessage", "Title": resources.Message, "Width": "40%", "Class": "no-wrap" },
                { "Data": "Read", "Title": resources.IsRead, "ShowIcon": true, "Type": "boolean" }
            ],
            quickFilter: {
                "DisplayMode": "buttons",
                "IncludeAll": false,
                "Items": [{ "Label": resources.Received, "AjaxParams": { "type": 0 } },
                        { "Label": resources.Sent, "AjaxParams": { "type": 1 } }]
            },
            toolBarItems: offlineMessaging.getToolBarItems(),
            contextMenuItems: offlineMessaging.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");
                var messageType = rows[0].MessageType;

                switch (action) {
                    case "delete":
                        offlineMessaging.deleteMessage(ids, messageType);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "read":
                        offlineMessaging.readMessage(row.Id);
                        break;
                    case "delete":
                        offlineMessaging.deleteMessage(row.Id, row.messageType);
                        break;
                }
            },
            loadData: function (event, data) {
                if (data.ajaxParams.tableParams.QuickFilter) {
                    var type = data.ajaxParams.tableParams.QuickFilter.type;
                    var createdOnTitle = type == 0 ? resources.Received : resources.Sent;

                    $(this).a4datatable("toggleColumns", ["Read", "SenderName", "Received"], type == 0);
                    $(this).a4datatable("toggleColumns", ["RecipientNames"], type == 1);
                    $(this).a4datatable("changeColumnTitle", "CreatedOn", createdOnTitle);
                }
            },
            localizableTexts: { "Search": resources.SearchMessages }
        });
    },
    deleteMessage: function (items, messageType) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }
        
        var message = messageType == 0 ? confirmDeleteReceivedMessageResources : confirmDeleteSentMessageResources;
        modalDialog.showConfirmDelete(message, function () {
            a4.callServerMethod(a4.getAction("DeleteMessages", "Offline", "Messaging"), { messageIds: items },
            function () {
                offlineMessaging.refreshDataTable();
                a4.updateUnreadMessagesCount();
            });
        }, itemsCount);
    },
    readMessage: function (itemId) {
        modalDialog.showWindow(a4.getAction("MessageEditor", "Offline", "Messaging", { id: itemId }), 400, 700, {
            afterClose: function () {
                offlineMessaging.refreshDataTable();
                a4.updateUnreadMessagesCount();
            }
        });
    },
    getContextMenuItems: function () {
        return [{ "Action": "read", "Label": resources.Read },
                { "Action": "delete", "Label": resources.Delete }];
    },
    getToolBarItems: function () {
        return [{ "Action": "delete", "Label": resources.Delete }];
    },
    bindEvents: function () {
        $(document).on("click", ".h-newMessage", function () {
            modalDialog.showWindow(a4.getAction("MessageEditor", "Offline", "Messaging", { id: 0 }), 400, 700, {
                afterClose: function () {
                    offlineMessaging.refreshDataTable();
                    a4.updateUnreadMessagesCount();
                }
            });
        });
    }
}

var messageEditor = {
    context: $(".v-messageEditor"),
    initialize: function () {
        $(".h-contactsMultiSelect", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetUsersForAutoComplete", "Shared"),
            valueProperty: "Id",
            labelProperty: "UserName",
            multipleSelection: true,
            hideSelectedItems: true,
            altValueField: $("#RecipientsJson", this.context)
        });
    }
}

$(document).ready(function () {
    if ($(".v-offlineMessaging").length > 0) {
        offlineMessaging.initializeDataTable();
        offlineMessaging.bindEvents();
    } else if ($(".v-messageEditor").length > 0) {
        messageEditor.initialize();
    }
});